﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP_WEB.Custom.EFR;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class BaseControlDropDownList : UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
        }
        public string Text
        {
            get
            {
                return HiddenFieldID.Value;
            }
            set
            {
                HiddenFieldID.Value = value;
                foreach (ListItem radioListItem in DropDownListID.Items)
                {
                    if (radioListItem.Value == value.Trim())
                    {
                        radioListItem.Selected = true;
                        break;
                    }
                }
            }
        }

        public void SetValueAsText()
        {
            foreach (ListItem radioListItem in DropDownListID.Items)
            {
                radioListItem.Value = radioListItem.Text;
            }
        }

        public string LabelText
        {
            get
            {
                return LabelforLabelID.Text;
            }
            set
            {
                LabelforLabelID.Text = value;
            }
        }

        public string Tooltip
        {
            set
            {
                LabelforLabelID.ToolTip = value;
                DropDownListID.ToolTip = value;
            }
        }

        public bool IncludeLabel
        {
            set
            {
                LabelforLabelID.Visible = value;
            }
        }

        public string LookUpCategory
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    List<EFR_VIEW_LOOKUP> lookupList = EFR_VIEW_LOOKUPManager.GetItemsByType(
                        HttpContext.Current.User.Identity.Name, GetCurrentRegistryId(), value);

                    DropDownListID.DataSource = lookupList;
                    DropDownListID.DataValueField = "ID";
                    DropDownListID.DataTextField = "NAME";
                    DropDownListID.DataBind();
                    AddAttributes();
                }
            }
        }

        private int GetCurrentRegistryId()
        {
            Control baseControl = Parent;
            EfrBasePage basePage = baseControl.Page as EfrBasePage;
            if (basePage != null)
                return basePage.CurrentRegistryId;

            return default(int);
        }

        public void LoadControlsFromObject(string text, string labelText, string tooltip, bool includeLabel, string lookupCategory)
        {
            if (!string.IsNullOrEmpty(tooltip))
            {
                Tooltip = tooltip;
            }
            if (!string.IsNullOrEmpty(text))
            {
                Text = text;
            }
            if (!string.IsNullOrEmpty(labelText))
            {
                LabelText = labelText;
            }

            IncludeLabel = includeLabel;
            LookUpCategory = lookupCategory;
        }

        private void AddAttributes()
        {
            if (DropDownListID.Attributes["onchange"] == null)
            {
                DropDownListID.Attributes.Add("onchange",
                    "SetBaseControlTextValue(this, '" + HiddenFieldID.ClientID + "')");
            }
        }
    }
}
